const originalStructure = {
    error: Boolean,
    category: String,
    type: String, // single, twopart
    setup: String, // for twopart type
    delivery: String, // for twopart type
    joke: String, // for single type
    flags: {
        nsfw: Boolean,
        religious: Boolean,
        political: Boolean,
        racist: Boolean,
        sexist: Boolean,
        explicit: Boolean
    },
    id: Number,
    safe: Boolean,
    lang: String
}



class JokeAPIHandler {

    formatResult(data) {
        if (data.type === 'single') {
            return {
                title: null,
                subtitle: null,
                content: data.joke
            }
        } else if (data.type === 'twopart') {
            return {
                title: null,
                subtitle: null,
                content: data.setup + "\n\n" + data.delivery
            }
        }
    }
}

module.exports = JokeAPIHandler;