const express = require('express');
const { specs, swaggerUi } = require('./config/swagger');
const app = express();

// Import users route
const usersRouter = require('./routes/users');
const jsonRouter = require('./routes/json');
const categoriesRouter = require('./routes/categories');
const subCategoriesRouter = require('./routes/subCategories');
const contentRouter = require('./routes/content');
const authTypesRouter = require('./routes/authTypes');

// Enable JSON body parsing (without this, req.body will be undefined in POST requests)
app.use(express.json());

// Use users route
app.use('/users', usersRouter);

app.use('/json', jsonRouter);

app.use('/categories', categoriesRouter);

app.use('/subcategories', subCategoriesRouter);

app.use('/content', contentRouter);

app.use('/auth-types', authTypesRouter);

// Add Swagger middleware
app.use('/api-docs', swaggerUi.serve, swaggerUi.setup(specs));



module.exports = app;