const { Client } = require('ssh2');
const mysql = require('mysql2/promise');

const sshConfig = {
    host: '66.29.132.77',
    port: 21098,
    username: 'trusfmao',
    password: 'beFc1jcErCBc', // or use privateKey
    // privateKey: require('fs').readFileSync('/path/to/private/key')
};

const dbConfig = {
    host: 'localhost', // or the database host from Namecheap
    port: 3306,
    user: 'trusfmao_social',
    password: 'vc0o.BiPtMh5',
    database: 'trusfmao_social'
};

async function connectViaSSH() {
    const sshClient = new Client();

    return new Promise((resolve, reject) => {
        sshClient.on('ready', async () => {
            console.log('SSH connection established');

            // Forward local port to remote database
            sshClient.forwardOut(
                '127.0.0.1',
                3306, // source address/port (arbitrary)
                '127.0.0.1', // destination host as seen from SSH server
                3306, // destination port (MySQL default)
                async (err, stream) => {
                    if (err) {
                        reject(err);
                        return;
                    }

                    // Create database connection through the SSH tunnel
                    const connection = await mysql.createConnection({
                        ...dbConfig,
                        stream: stream, // Use the SSH stream
                        host: 'localhost', // MySQL host as seen from your app
                        port: 3306
                    });

                    resolve(connection);
                }
            );
        });

        sshClient.on('error', (err) => {
            reject(err);
        });

        sshClient.connect(sshConfig);
    });
}

// Usage

async function connectDB() {
    try {
        // Check if running on Namecheap hosting (production)
        // You can set NODE_ENV=production or a custom env var on your hosting
        const isProduction = process.env.NODE_ENV === 'production' || process.env.ON_NAMECHEAP === 'true';

        let dbConnection;
        if (isProduction) {
            // Direct connection (no SSH tunnel)
            dbConnection = await mysql.createConnection(dbConfig);
            console.log('Database connected directly (production/hosting)');
        } else {
            // Local development: connect via SSH tunnel
            dbConnection = await connectViaSSH();
            console.log('Database connected via SSH (development)');
        }
        return dbConnection;
    } catch (error) {
        console.error('Connection failed:', error);
    }
}

exports = module.exports = connectDB;