// swagger.js
const swaggerJsdoc = require('swagger-jsdoc');
const swaggerUi = require('swagger-ui-express');

const options = {
    definition: {
        openapi: '3.0.0',
        info: {
            title: 'My Express API',
            version: '1.0.0',
            description: 'A simple Express API with Swagger documentation',
        },
        servers: [
            {
                url: 'http://localhost:3000', // Replace with your server URL
            },
        ],

        tags: [
            {
                name: 'Users',
                description: 'API for user management',
            },
            {
                name: 'json',
                description: 'API for JSON data',
            },
        ],
    },
    apis: ['routes/*.js', 'server.js'], // Path to the API route files you want to document
};

const specs = swaggerJsdoc(options);

module.exports = {
    specs,
    swaggerUi,
};